﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="ucTBICDSInstrument.ascx.cs" Inherits="ucTBICDSInstrument" ClassName="ucTBICDSInstrument" %>

<!-- Load CSS -->
<link href="css/bootstrap.min.css" rel="stylesheet" />
<link href="css/bootstrap.cerulean.min.css" rel="stylesheet" />
<link href="css/instruments.css" rel="stylesheet" />

<div id="divQuestions" runat="server">
    <asp:Xml ID="xmlQuestionnaire" runat="server"></asp:Xml>
</div>

<asp:Panel ID="aspPnlSaveBtn" runat="server" Visible="false">
    <div style="clear: both;"></div>
    <%--<div id="divSaveResponses" style="margin-top: 10px; text-align: center;">
            <input type="button" value="I'm finished!" class="button-blue" onclick="App.direct.INSTRUMENTS.AddInstrumentResponses({ success: fnSuccessAddResponses, failure: fnFailureAddResponses });" />
        </div>--%>
</asp:Panel>


<%-- ############################################### --%>
<%-- ############################################### --%>
<%--                     SCRIPTS                     --%>
<%-- ############################################### --%>
<%-- ############################################### --%>


<script type="text/javascript">

    var qSetOptions = function (strSkipPatterns, strTestMasks) {

        /*get module's skip pattern*/
        var s = strSkipPatterns,
            sPatt = null;

        if (typeof (strSkipPatterns) !== "object") {
            try {
                sPatt = JSON.parse(s);
            } catch (err) {
                sPatt = null;
            }
        }
        else {
            sPatt = strSkipPatterns;
        }

        if (sPatt) {
            question.opts.skipPatterns = sPatt.skipPattern;
        }
        else {
            question.opts.skipPatterns = {};
        }

        /*get module's masks pattern*/
        var m = strTestMasks,
            mMask = null;

        if (typeof (strTestMasks) !== "object") {
            try {
                mMask = JSON.parse(m);
            } catch (err) {
                mMask = null;
            }
        }
        else {
            mMask = strTestMasks;
        }

        if (mMask) {
            question.opts.txtMasks = mMask.txtMasks;
        }
        else {
            question.opts.txtMasks = {};
        }
    },
        qSetOptionsObj = function (opts) {
            var oSkipPattern = Ext.JSON.decode(opts.SkipPattern, true),
                oTextMasks = Ext.JSON.decode(opts.TextMask, true);
            qSetOptions(oSkipPattern, oTextMasks);

            question.opts.responsesData = Ext.JSON.decode(opts.ResponsesData, true);

            /*question.init();*/
        };

    /*question.init();*/

    var fnFeedbackAddResponses = function (title, message) {
        App.direct.ShowSystemFeedback(message, title);
    },

        fnSuccessAddResponses = function (result) {

            var title = "SAVED",
                 message = "Responses were successfully saved in the database!";

            if (!result.saved) {
                title = result.title;
                message = result.message;
            }

            if (result.score_error || result.score_error_msg.length > 0) {
                title = "Scoring Error";
                message = result.score_error_msg;
                if (result.status_code == 2) {
                    fnResetInstrument(result.patient_id, result.mid, result.intake_id, result.cpa_id, result.pat_pw_id, result.pat_pw_event_id, result.pw_event_module_id);
                }
            }

            if (result.saved) {
                arrOriginalResponses = fnInstrumentSnapshot();
                fnShowInstrumentReport(result.patient_id, result.mid, result.intake_id, result.cpa_id, result.pat_pw_id, result.pat_pw_event_id, result.pw_event_module_id);
            }

            fnFeedbackAddResponses(title, message);
        },
        fnFailureAddResponses = function (errorMessage) {
            var title = "ERROR",
                message = errorMessage;

            fnFeedbackAddResponses(title, message);
        },

        fnSelectedInstrument = function (readOnly) {
            if (readOnly) {
                /*Read Only*/
                App.btnFinished.hide();
                $('input, select, textarea', $('[id$="divQuestions"]')).attr('readonly', true);
                $('input', $('[id$="divQuestions"]')).attr('disabled', true);
                $('select').attr('disabled', true);
            }
            else {
                App.btnFinished.show();
                $('input, select, textarea', $('[id$="divQuestions"]')).attr('readonly', false);
                $('input', $('[id$="divQuestions"]')).attr('disabled', false);
                $('select').attr('disabled', false);
            }
            return;
        };

    var fnInstrumentSnapshot = function () {
        var _responses = [],
            _divQs;

        _divQs = $('div.question-container').filter(function (i, ele) {
            return $('input[type="radio"], input[type="checkbox"], input[type="text"], select, textarea', ele).length > 0;
        });

        $("[name^='grp']:checked, select", $(_divQs)).each(function () {
            _responses.push($(this).val() || '');
        });

        $("input[type='text'], textarea", _divQs).each(function () {
            _responses.push($(this).attr('id') + '|' + $(this).val());
        });
        return _responses;
    };

    var fnDidInstrumentChange = function (arrOriginalResponses, arrNewResponse) {
        if (arrOriginalResponses.length == arrNewResponse.length) {
            return $(arrNewResponse).not(arrOriginalResponses).get().length > 0;
        }
        else {
            return true;
        }
    };
</script>
